/*
iskender atasoy
email iskenderatasoy@yahoo.co.uk
free usage
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <sys/sysinfo.h>
#include <linux/version.h>

void get_ram_info();

int main(){
    get_ram_info();
return 0;
}
void get_ram_info()
{
	struct sysinfo system_info;
	int error;
	while(1){
		error=sysinfo(&system_info);
		if(error < 0){
			error=errno;
			/* Error Found ...Print an error message and exit. */
			fprintf (stderr, "Error Definations is: %s\n", strerror (error));
			exit (1);
		}
		system("clear");
		printf("\t\t\tMemory Browser Text Versions\n");
		printf("\t\t\tTo Exit use CTR+C\n\n");
		printf("\t\t\tTotal      Ram Size	: %ld\n",(long)system_info.totalram);
		printf("\t\t\tFree       Ram Size	: %ld\n",(long)system_info.freeram);
		printf("\t\t\tShared     Ram Size	: %ld\n",(long)system_info.sharedram);
		printf("\t\t\tBuffered   Ram Sizi     : %ld\n",(long)system_info.bufferram);
		printf("\t\t\tTotal Swap Size         : %ld\n",(long)system_info.totalswap);
		printf("\t\t\tFree  Swap Size         : %ld\n",(long)system_info.freeswap);
		printf("\t\t\tNumber Of Proses        : %d \n",(short int)system_info.procs);
		//these code block works 2.3.23-48 kernel version 
		//if our kernel number less than it error can happend
		//if kernel >2.3.23 use these else not
		if(strcmp("2.3.23",UTS_RELEASE)<0 && strcmp(UTS_RELEASE,"2.3.48")>0){
	  	  printf("\t\t\tTotal High Memory Size  : %ld\n",(long)system_info.totalhigh);
		  printf("\t\t\tAvailable High Mem.Size : %ld\n",(long)system_info.freehigh);
		  printf("\t\t\tMemory Unit Sizes       : %ld\n",(long)system_info.mem_unit);
		}
		sleep(2);
	}
}
