#include <stdio.h>
#include <stdlib.h>
#include <time.h>  //ctime fonk.
#include <sys/stat.h> //stat fonk.
#include <sys/types.h>
#include "size.h"

 
// int stat(const char *file_name, struct stat *buf);
void get_file_info(char *filename)
{
	struct stat *status;
	char *temp;
	
	status=(struct stat *) malloc( sizeof(struct stat) );
	temp  =(char *) malloc(9);
	
	if(!status || !temp){
		printf("size.c error ! not free memory\n");
		exit(0);
	}	
	system("clear");
	printf("\t\t    FILE INFORMATIONS\n\n");
	if(!stat(filename,status)){
		printf("File Name is     : %s\n",filename);
		printf("Sizeof File      : %ld Byte or %.2f KB %.2f MB %.4f GB \n",
		                        status->st_size,
					(float)(status->st_size)/(1024),
					(float)(status->st_size)/(1024*1024),
					(float)(status->st_size)/(1024*1024*1024));
		printf("Group  ID        : %d\n",status->st_gid);
		printf("User   ID        : %d\n",status->st_uid);
		printf("Last Access Time : %s",ctime(&status->st_atime));
		printf("Last Modify Time : %s",ctime(&status->st_mtime));
		printf("Last Change Time : %s",ctime(&status->st_ctime));
		printf("I-node no        : %ld\n",(long)status->st_ino);
		printf("Hardlink Numbers : %ld\n",(long)status->st_nlink);
		getaccess(temp,status);	
		printf("Access           : %s\n",temp);	
		if(S_ISREG(status->st_mode))
		        printf("%s   is a regular file\n",filename);
		else 
		if(S_ISDIR(status->st_mode))
		        printf("%s   is a      directory\n",filename);
		else
                 if( S_ISCHR(status->st_mode) )
		        printf("%s   is a character device\n",filename);
                else
                 if( S_ISBLK(status->st_mode) )
		        printf("%s   is a block device\n",filename);
		else
                if( S_ISFIFO(status->st_mode) )
		        printf("%s   is a fifo\n",filename);
		else
                if( S_ISLNK(status->st_mode) )
		          printf("%s   is a symbolic link\n",filename);
                 else                                                               
		        printf("%s   is socket\n",filename);                                     
		
		free(temp);
		free(status);
		getchar();
		exit(0);
	}
	else{
		printf("Cannot access of %s\n",filename);
		exit(0);
	}
}


void getaccess(char *access,struct stat *status){
int i=9;
char c;
        //to show much more good style
	switch((unsigned int)i%9){
	    case 0 : 
	                if (status->st_mode & S_IRUSR  ) c='r' ; else  c='-' ;  access[0]=c;
	    case 1 :
	                 if (status->st_mode & S_IWUSR  ) c='w' ; else  c='-' ;  access[1]=c; 
	    case 2 :
	                 if (status->st_mode & S_IXUSR  ) c='x' ; else  c='-' ;  access[2]=c; 
	    case 3 :
	                 if (status->st_mode & S_IRGRP  ) c='r' ; else  c='-' ;  access[3]=c; 
	    case 4 :
	                 if (status->st_mode & S_IWGRP  ) c='w' ; else  c='-' ;  access[4]=c; 
	    case 5 :
	                 if (status->st_mode & S_IXGRP  ) c='x' ; else  c='-' ;  access[5]=c; 
	    case 6 :
	                 if (status->st_mode & S_IROTH  ) c='r' ; else  c='-' ;  access[6]=c;
	    case 7 :
	                 if (status->st_mode & S_IWOTH  ) c='w' ; else  c='-' ;  access[7]=c;
	    case 8 :
	                 if (status->st_mode & S_IXOTH  ) c='x' ; else  c='-' ;  access[8]=c;
			 break;
	}
}
