#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>

#include  "info.h"       
#include "eject.h"
#include "size.h"

#define VERSION "LetsLook version 0.1   iskender atasoy(iskenderatasoy@yahoo.co.uk)\n"

char    *prog_name;
void print_help (FILE* stream, int exitcode);

int main(int argc,char **argv){
	//next command options
	int next_command;
	//command options
	char *command_options=NULL;
	//short commands of our programs
	const char* const   short_commands="e:hi:s:v";    
	//long commands options
	const struct option long_commands[]={
		{"eject"  , 1 , NULL , 'e' },
		{"help"   , 0 , NULL , 'h' },
		{"info"   , 1 , NULL , 'i' },
		{"size"   , 1 , NULL , 's' },
		{"version", 0 , NULL , 'v' },
		{ NULL	  , 0 , NULL , 0   }
	};	       
	
	//program name
        prog_name=argv[0];
	
	do{
		next_command=getopt_long(argc,argv,short_commands,long_commands,NULL);
		switch(next_command){
			case 'e':
				/*eject to the cdroms*/
				command_options=optarg;
				eject(command_options);
				exit(0);
			case 'h':
				/*display the help*/
				print_help(stdout,0);	
			case 'i':
				/*gives informations about valid arguments */
				command_options=optarg;
				info(command_options);
			case 's':
				/*gives informations about the files*/
				command_options=optarg;
				get_file_info(command_options);
				exit(0);
			case 'v':
				printf(VERSION);
				exit(0);
			case '?':
//				break;
			case -1:
				print_help(stderr,2);
				break;
			default:
				print_help(stderr,2);				
				abort();
		}
	}while(next_command != -1);
        return 0;
}

void print_help (FILE* stream, int exitcode)
{
        fprintf (stream, "Usage:  %s  command [options]\n", prog_name);
        fprintf (stream,
		VERSION
		"\n"
		"-e    --eject      [<eoptions>       --eject    to  current cdroms\n"	
                "-h    --help                         --display  the usage and exits\n"
                "-i    --info       [<options>]       --display  the selected options\n"			    "-s    --size       [<filename>]      --display  the size and informations\n"
		"-v    --version                      --display  the program version\n\n"	
		"[<eoptions>]\n"
		"You can use cdrom/cdrom1/cdrom2..N likes these\n"
		"Example : program -e/--eject cdrom/cdrom1/cdrom2.. likes \n\n"	
		"[<options>]\n"
		"cdrom     --Display the Cdrom/s    informations\n"
		"cpu  	  --Display the CPU        informations\n"
		"disk	  --Dislpay the partitions informations\n"
		"dma	  --Display the using  DMA informations\n"
		"ide	  --Display the IDE        informations\n"
		"interrups --Display the interrup   informations\n"
		"iomemory  --Display the I/O Memory informations\n"
		"ioport    --Display the I/O Ports  informations\n"
		"memory	  --Display the memory	   informations\n"	
		"pci	  --Display the PCI        informations\n"
		"system	  --Display the system     informations\n"
		"user	  --Display the current user informations\n\n"
           );									
        exit (exitcode);
}
