#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <sys/sysinfo.h>
#include <linux/version.h>
#include <sys/utsname.h>
#include <pwd.h>
#include <sys/types.h>
#include <ctype.h>
#include "info.h"

enum cases{CDROM=0,CPU,DISK,DMA,IDE,INTERRUPS,
                IOMEMORY,IOPORT,MEMORY,PCI,XWINDOW,SYSTEM,USER};	
		

void info(char  *device){
        int  i=0;
	int  options=-1;
	enum cases cases;
        char *command[]={ "cdrom"       , "cpu"          ,"disk"            , "dma",
	                                 "ide"             , "interrups"  ,"iomemory"  ,"ioport",
					 "memory"    , "pci"            ,"xwindow","system"       , "user"};
					 
        //find the command index size in our arrays					 
	for(;command[i]!=NULL;++i){
	        //if found break the look
	        if( strcmp(device,command[i])==0)
		{
		        options=i;
			break;
	       }				 
	}
	
	//we have got 13 command know
	//if command not exist gives the -1
	//and out of the program
	        
        cases=options;	
	//some options
	switch(cases){
	        case CDROM          :
	                        	system("clear");
                                	printf("\t\tCURRENT  CDROMS INFORMATION\n\n");
					show_cdroms();
		case CPU                :
		                        show_devices("cpuinfo");
					exit(0);
		
		case DISK             :
					show_disk();	
					exit(0);
		
		case DMA               :
		                        show_devices("dma");
					exit(0);
		
		case IDE                  :
	                        	system("clear");
                                	printf("\t\tCURRENT  IDE  INFORMATION\n\n");
		                        show_ide();
		                        show_cdroms();
					exit(0);
		
		case INTERRUPS    :
					show_devices("interrupts");
					exit(0);
		
		case IOMEMORY  :
		                        show_devices("iomem");
					exit(0);
		
	        case IOPORT        :
		                        show_devices("ioports");
					exit(0);
		case MEMORY     :
		                        show_memory();
					exit(0);
		
		case PCI                : 
		                        //actualy show_devices("ioports"); works
					//but we use strtrim for that more good secreen view we
					//dont use trim functions thats all
					show_pci();
					exit(0);
		case XWINDOW       : 
		                        //in future maybe i can put  a xwindow version memory browser
					exit(0);
				
		case SYSTEM      :
		                         show_system();
					exit(0);
		
		case USER	        :
		                         show_user();
					exit(0);
                default:					
                        	        fprintf(stderr,"Informations Errors ! Command is not executable re-try\n");
		                        exit(0);
	}
	exit(0);
	
}

void show_cdroms()
{
        //normaly people have not more than 2 CDROMs
	//like /dev/hdc /dev/hdd likes
	//there can be also done linked list which /proc/hd*  all
	//but no one use more than 2 CDROMS thats all
	char   *dirs;
	char  buffer[128];
	int isshow=1;
	char *cdrom_dirs[]={"/proc/ide/hdc/","/proc/ide/hdd/",NULL} ;
	char *cdrom_options[]={"media","model","driver",NULL};
	FILE *fp;
	int i,j;
	
	for(i=0;cdrom_dirs[i]!=NULL;++i)
	{
	        //printf("%s options      \n\n",str2upper(cdrom_dirs[i]) );
		fprintf(stdout,"\t%s options      \n\n",cdrom_dirs[i]);
		
	        for(j=0;cdrom_options[j]!=NULL;++j)
		{
		        dirs=(char *)malloc(sizeof(char)*256);
			if(!dirs)
			{
			        break;
			}
			else
			{
				memset(dirs,0,sizeof(dirs));
				strcpy(dirs,cdrom_dirs[i]);
				strcat(dirs,cdrom_options[j]);


				fp=fopen(dirs,"r");
				if(!fp)
				{
					isshow=0;	
				}

				//this mean no error it can visible
				if(isshow)
				{
					fgets(buffer,sizeof(buffer),fp);
					printf("%s\tnames\t: %s",cdrom_options[j],buffer);
	        			fclose(fp);
				}
       				free(dirs);

			}
	        }
		printf("\n");
	}
        getchar();
	exit(0);	
}

void show_ide()
{
	char   *dirs;
	char  buffer[128];
	int isshow=1;
	char *cdrom_dirs[]={"/proc/ide/hda/","/proc/ide/hdb/",NULL} ;
	char *cdrom_options[]={"media","model","driver",NULL};
	FILE *fp;
	int i,j;
	
	for(i=0;cdrom_dirs[i]!=NULL;++i)
	{
	        //printf("%s options      \n\n",str2upper(cdrom_dirs[i]) );
		fprintf(stdout,"\t%s options      \n\n",cdrom_dirs[i]);
		
	        for(j=0;cdrom_options[j]!=NULL;++j)
		{
		        dirs=(char *)malloc(sizeof(char)*256);
			if(!dirs)
			{
			        break;
			}
			else
			{
				memset(dirs,0,sizeof(dirs));
				strcpy(dirs,cdrom_dirs[i]);
				strcat(dirs,cdrom_options[j]);


				fp=fopen(dirs,"r");
				if(!fp)
				{
					isshow=0;	
				}

				//this mean no error it can visible
				if(isshow)
				{
					fgets(buffer,sizeof(buffer),fp);
					printf("%s\tnames\t: %s",cdrom_options[j],buffer);
	        			fclose(fp);
				}
       				free(dirs);

			}
	        }
		printf("\n");
	}
}


void show_disk(){
        char    disk[64];
	char    command[128];
	
	//make emtpy array
	memset(disk,0,sizeof(disk));
	printf("Which Disk You Want to See Partition Table\n\n");
        printf("E.g.  :         /dev/hda  (for the first IDE disk)\n");
        printf("           or:  /dev/sdc  (for the third SCSI disk)\n");
        printf("           or:  /dev/eda  (for the first PS/2 ESDI drive)\n");
        printf("           or:  /dev/rd/c0d0  or: fdisk /dev/ida/c0d0  (for RAID devices)\n\n");
	
	printf("Disk Name :");
	fgets(disk,sizeof(disk),stdin);
        
	strcpy(command,"fdisk -l ");         
	strcat(command,disk);
	system("clear");
	printf("TO CHANGE PARTİTIONS TABLE USE FDISK\n");        					
	system(command);
	getchar();
}


void show_memory()
{
	struct sysinfo system_info;
	int error;
	while(1){
		error=sysinfo(&system_info);
		if(error < 0){
			error=errno;
			/* Error Found ...Print an error message and exit. */
			fprintf (stderr, "Error Definations is: %s\n", strerror (error));
			exit (1);
		}
		system("clear");
		printf("\t\t\tMemory Browser Text Versions\n");
		printf("\t\t\tTo Exit use CTR+C\n\n");
		printf("\t\t\tRam Usage         	: %c %.2f \n",'%',
		(100.0-100*(system_info.freeram/(float)system_info.totalram)));		
		printf("\t\t\tSwap Usage        	: %c %.2f \n",'%',
		(100.0-100*(system_info.freeswap/(float)system_info.totalswap)));		
		printf("\t\t\tTotal      Ram Size	: %ld\n",(long)system_info.totalram);
		printf("\t\t\tFree       Ram Size	: %ld\n",(long)system_info.freeram);
		printf("\t\t\tShared     Ram Size	: %ld\n",(long)system_info.sharedram);
		printf("\t\t\tBuffered   Ram Size     : %ld\n",(long)system_info.bufferram);
		printf("\t\t\tTotal Swap Size         : %ld\n",(long)system_info.totalswap);
		printf("\t\t\tFree  Swap Size         : %ld\n",(long)system_info.freeswap);
		printf("\t\t\tNumber Of Proses        : %d \n",(short int)system_info.procs);
		//these code block works 2.3.23-48 kernel version 
		//if our kernel number less than it error can happend
		//if kernel >2.3.23 use these else not
		if(strcmp("2.3.23",UTS_RELEASE)<0 && strcmp(UTS_RELEASE,"2.3.48")>0){
	  	  printf("\t\t\tTotal High Memory Size  : %ld\n",(long)system_info.totalhigh);
		  printf("\t\t\tAvailable High Mem.Size : %ld\n",(long)system_info.freehigh);
		  printf("\t\t\tMemory Unit Sizes       : %ld\n",(long)system_info.mem_unit);
		}
		sleep(2);
	}

}

char *str2upper(char *str){
int i=0;
char *buffer;
        //to become more safely using  i am using temp variable
        buffer=(char *)malloc(strlen(str)+1);
	
        if(!buffer){
                fprintf(stderr,"Not Enough Memory To Uppercase\n");
                return str;
        }
        
	memcpy(buffer,'\0',strlen(buffer)); 
        for(;str[i]!=(char)NULL;++i)
                buffer[i]=(char)toupper((int)str[i]);
return buffer;
}

/*to delete the spaces from left side*/
char *strtrim(char *str){
char *buffer;
int i;

        for(i=0;str[i]!=(char)NULL;++str){
                if(str[i]==(char)32)
                ;
                else
                break;
        }
        buffer=str;
return buffer;
}

void show_devices(char *devices){
	FILE  *fp;
        char    file_name[256]="/proc/";
	int i=0;
	char ch;
	char buffer[128];
	//7 is /proc/ sizes
	if(strlen(devices)<sizeof(file_name)-7){
	        //open for reading /proc/ files
		strcat(file_name,devices);
		printf("%s\n",file_name);
	        fp=fopen(file_name,"r");
	
	        //if not exist out the programs
	        if(fp==NULL)
	        {
	                fprintf(stderr,"İnformation Error !  couldn't  load  %s  informations re-try\n",devices);
		        exit(0);
	        }
	
	        system("clear");
	        printf("\t\tCURRENT %s  INFORMATION\n\n",str2upper(devices));
	        while(!feof(fp)){
	                fgets(buffer,sizeof(buffer),fp);
		        printf("%s",strtrim(buffer));
		        ++i;
		        
		        if(i==25){
		                printf("To Show Next Page[n or N] Print Enter\n");
			
		                ch=getchar();
			        if(ch=='n' || ch=='N'){
			                system("clear");
                                        printf("\t\tCURRENT %s  INFORMATION Next Page\n\n",str2upper(devices));
                	                fgets(buffer,sizeof(buffer),fp);
		                        printf("%s",strtrim(buffer));
        		        }
			        else
			                exit(0);
		        }
                }
	fclose(fp);
	}
	else
	printf("File Name is Too long\n");
	getchar();

}

void show_system(){
	struct sysinfo system_info;
        struct utsname utsname;
	int error;
	char  name[256];

	system("clear");
	printf("\t\tCURRENT SYSTEM INFORMATIONS\n\n"); 
		
	if(uname(&utsname) <0 ){
	        fprintf(stderr,"System Error ! Can not learn System Informations re-try \n ");
		exit(0);
	}
	else 
	{     
	        memset(name,0,sizeof(name));
	
	        printf("System  Names               : %s\n",utsname.sysname);
		printf("System  NodeName            : %s\n",utsname.nodename);
		printf("System  Kernel Version      : %s\n",utsname.release);
		printf("System  Version             : %s\n",utsname.version);
		printf("System  Architecture        : %s\n",utsname.machine);

		#ifdef  USE_GNU
			printf("System Domain Name          :  %s\n",utsname.domainname);
		#else
			if(gethostname(name,256)>=0)
				printf("System  Domain Name         : %s\n",name);
			else
				fprintf(stderr,"System Error ! Error types %s\n",strerror(errno));
		#endif
        }	
        //we use these for  it every dynamic constant	
	//memset(name,0,sizeof(name));
	
	printf("Using   Bash Types          : %s\n",getusershell());
	printf("Current User Types          : %s\n",getlogin());
	get_cpu_vendorid();
	get_cpu_types();	
	get_cpu_clock();
	
	error=sysinfo(&system_info);
	
	if(error < 0){
		/* Error Found ...Print an error message and exit. */
		fprintf (stderr, "Error becomes %s\n",strerror(error));
		exit (1);
	}
	printf("Total   Ram   Size          : %ld MB\n",system_info.totalram/(1024*1024));
	printf("Total   Swap Size           : %ld MB\n",system_info.totalswap/(1024*1024));
	getchar();              
}

//can looking from file name to words
void get_cpu_clock(){
        
        FILE    *fp;
	char    buffer[1024];
	size_t  readbytes;
	char  *match;
	float  wanted_word;
	
	fp=fopen("/proc/cpuinfo","r");
	
	if(!fp)
	{
	        fprintf(stderr,"/proc/cpuinfo can not opened\n");
                exit(0);
	}

	readbytes= fread (buffer, 1, sizeof (buffer), fp);
	fclose(fp);	

	if (readbytes == 0 || readbytes == sizeof (buffer))
	exit(0);
	/* NULL -terminate the text. */
	buffer[readbytes] = '\0';
	/* Locate the line that starts with "cpu MHz". */

	match=strstr(buffer,"cpu MHz");
	if (match == NULL)
	{
	        perror("Not Enough Memory\n");
	        exit(0);
	}

	/* Parse the line to extract the clock speed. */
	sscanf (match, "cpu MHz : %f",&wanted_word);
	printf("CPU     Clock               : %.2f MHz\n",wanted_word);
}

//can looking from file name to words
void get_cpu_vendorid(){
        FILE    *fp;
	char    buffer[1024];
	size_t  readbytes;
	char  *match;
	char  wanted_word[256];
	
	fp=fopen("/proc/cpuinfo","r");
	
	if(!fp)
	{
	        fprintf(stderr,"/proc/cpuinfo can not opened\n");
                exit(0);
	}

	readbytes= fread (buffer, 1, sizeof (buffer), fp);
	fclose(fp);	

	if (readbytes == 0 || readbytes == sizeof (buffer))
	return ;
	/* NULL -terminate the text. */
	buffer[readbytes] = '\0';
	/* Locate the line that starts with "vendor id". */

	match=strstr(buffer,"vendor_id");
	if (match == NULL)
	{
	        perror("Not Enough Memory\n");
	        exit(0);
	}
	
	/* Parse the line to extract the vendor id */
	sscanf (match, "vendor_id : %s",wanted_word);
	printf("CPU     Vendor id           : %s\n",wanted_word);
}

//can looking from file name to words
void get_cpu_types(){
        FILE    *fp;
	char    buffer[1024];
	size_t  readbytes;
	char  *match;
	char  wanted_word[256];
	
	fp=fopen("/proc/cpuinfo","r");
	
	if(!fp)
	{
	        fprintf(stderr,"/proc/cpuinfo can not opened\n");
                exit(0);
	}

	readbytes= fread (buffer, 1, sizeof (buffer), fp);
	fclose(fp);	

	if (readbytes == 0 || readbytes == sizeof (buffer))
	return ;
	/* NULL -terminate the text. */
	buffer[readbytes] = '\0';
	/* Locate the line that starts with "model name". */

	match=strstr(buffer,"model name");
	if (match == NULL)
	{
	        perror("Not Enough Memory\n");
	        exit(0);
	}
	
	/* Parse the line to extract the model name */
	sscanf (match, "model name : %s",wanted_word);
	printf("CPU     Types               : %s\n",wanted_word);
}

void show_user(){
        struct passwd *pwd;          /*current user password data structure*/
        int uid;
         
        uid = getuid();                        /*get the user's id number*/
        pwd = getpwuid(uid);          /*get the current process id (this program!)*/
	
	system("clear");
	printf("\t\tCURRENT USER INFORMATIONS\n\n");
	
	if(pwd !=NULL){
		printf("User Name            : %s\n",pwd->pw_name);       /* user name */
		if(!( pwd->pw_passwd==(char *)'x'))
			printf("User  Password       : Shadow Password Enables look /etc/shadow\n");
		else
			printf("User  Password       : %s\n",pwd->pw_passwd);
		printf("User  ID             : %d\n",(uid_t)pwd->pw_uid);         /* user id */
		printf("Group ID             : %d\n",(gid_t)pwd->pw_gid);         /* group id */
		printf("Real    Name         : %s\n",pwd->pw_gecos);      /* real name */
		printf("Home Directory       : %s\n",pwd->pw_dir);        /* home directory */
		printf("Shell Program        : %s\n",pwd->pw_shell);      /* shell program */
		getchar();
        }
	else
	{
	        perror("Can not Acces to User Knowledges\n");
		exit(0);
	}	

}

void show_pci(){
	FILE  *fp;
        char    file_name[256]="/proc/pci";
	int i=0;
	char ch;
	char buffer[128];
	        fp=fopen(file_name,"r");
	
	        //if not exist out the programs
	        if(fp==NULL)
	        {
	                fprintf(stderr,"İnformation Error !  couldn't  load  pci informations re-try\n");
		        exit(0);
	        }
	
	        system("clear");
	        printf("\t\tCURRENT PCI INFORMATION\n\n");
	        while(!feof(fp)){
	                fgets(buffer,sizeof(buffer),fp);
		        printf("%s",buffer);
		        ++i;
		        
		        if(i==25){
		                printf("To Show Next Page[n or N] Print Enter\n");
			
		                ch=getchar();
			        if(ch=='n' || ch=='N'){
			                system("clear");
                                        printf("\t\tCURRENT PCI  INFORMATION Next Page\n\n");
                	                fgets(buffer,sizeof(buffer),fp);
		                        printf("%s",buffer);
        		        }
			        else
			                exit(0);
		        }
                }
	fclose(fp);
	getchar();
}
